<?php

namespace App\Http\Resources;

use App\Traits\HasImageUrl;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AboutUsPageAfterOurVisionSectionResource extends JsonResource
{
    use HasImageUrl;

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'paragraph' => $this->paragraph,
            'image_1' => $this->getFullImageUrl($this->image_1),
            'image_2' => $this->getFullImageUrl($this->image_2),
            'image_3' => $this->getFullImageUrl($this->image_3),
            'image_4' => $this->getFullImageUrl($this->image_4),
            'status' => $this->status?->value,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
