<?php

use App\Http\Controllers\Api\AboutUsController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\HomepageController;
use App\Http\Controllers\Api\HomepageAboutUsSectionController;
use App\Http\Controllers\Api\HomepageCtaSectionController;
use App\Http\Controllers\Api\HomepageHeroSectionController;
use App\Http\Controllers\Api\OtpController;
use App\Http\Controllers\Api\PasswordResetController;
use App\Http\Controllers\Api\PrivilegeController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\UserController;
use Illuminate\Support\Facades\Route;

Route::prefix('auth')->group(function () {
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);

    // Password reset routes (public)
    Route::post('/forgot-password', [PasswordResetController::class, 'forgotPassword']);
    Route::post('/reset-password', [PasswordResetController::class, 'resetPassword']);

    // OTP routes (public)
    Route::post('/send-otp', [OtpController::class, 'sendOtp']);
    Route::post('/verify-otp', [OtpController::class, 'verifyOtp']);

    Route::middleware('auth:api')->group(function () {
        Route::get('/me', [AuthController::class, 'me']);
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::post('/refresh', [AuthController::class, 'refresh']);
    });
});

// Public Routes
Route::get('/homepage-hero-sections/active', [HomepageHeroSectionController::class, 'show']);
Route::get('/homepage-about-us-sections/active', [HomepageAboutUsSectionController::class, 'show']);
Route::get('/homepage-cta-sections/active', [HomepageCtaSectionController::class, 'show']);

Route::middleware('auth:api')->group(function () {
    // Profile routes
    Route::prefix('profile')->group(function () {
        Route::get('/', [ProfileController::class, 'show'])->middleware('privilege:read-profile');
        Route::put('/', [ProfileController::class, 'update'])->middleware('privilege:update-profile');
    });

    // Privilege routes
    Route::prefix('privileges')->group(function () {
        Route::get('/', [PrivilegeController::class, 'index'])->middleware('privilege:read-privileges,read-roles,assign-privileges-to-roles');
        Route::get('/{privilege}', [PrivilegeController::class, 'show'])->middleware('privilege:read-privileges,read-roles,assign-privileges-to-roles');
    });

    // Role routes
    Route::prefix('roles')->group(function () {
        Route::get('/', [RoleController::class, 'index'])->middleware('privilege:read-roles,assign-privileges-to-roles');
        Route::get('/{role}', [RoleController::class, 'show'])->middleware('privilege:read-roles,assign-privileges-to-roles');
        Route::post('/', [RoleController::class, 'store'])->middleware('privilege:create-roles');
        Route::put('/{role}', [RoleController::class, 'update'])->middleware('privilege:update-roles');
        Route::patch('/{role}', [RoleController::class, 'update'])->middleware('privilege:update-roles');
        Route::delete('/{role}', [RoleController::class, 'destroy'])->middleware('privilege:delete-roles');
        Route::post('/{role}/privileges', [RoleController::class, 'assignPrivileges'])->middleware('privilege:assign-privileges-to-roles');
        Route::delete('/{role}/privileges', [RoleController::class, 'removePrivileges'])->middleware('privilege:assign-privileges-to-roles');
        Route::delete('/{role}/privileges/{privilege}', [RoleController::class, 'removePrivilege'])->middleware('privilege:assign-privileges-to-roles');
    });

    // User routes
    Route::prefix('users')->group(function () {
        Route::get('/', [UserController::class, 'index'])->middleware('privilege:read-users');
        Route::get('/{user}', [UserController::class, 'show'])->middleware('privilege:read-users');
        Route::post('/{user}/suspend', [UserController::class, 'suspend'])->middleware('privilege:suspend-users');
        Route::post('/{user}/unsuspend', [UserController::class, 'unsuspend'])->middleware('privilege:suspend-users');
    });


    // Homepage Hero Section routes (Admin)
    Route::prefix('homepage-hero-sections')->group(function () {
        Route::get('/', [HomepageHeroSectionController::class, 'index'])->middleware('privilege:read-homepage-hero-sections');
        Route::get('/{homepageHeroSection}', [HomepageHeroSectionController::class, 'showById'])->middleware('privilege:read-homepage-hero-sections');
        Route::post('/', [HomepageHeroSectionController::class, 'store'])->middleware('privilege:create-homepage-hero-sections');
        Route::put('/{homepageHeroSection}', [HomepageHeroSectionController::class, 'update'])->middleware('privilege:update-homepage-hero-sections');
        Route::delete('/{homepageHeroSection}', [HomepageHeroSectionController::class, 'destroy'])->middleware('privilege:delete-homepage-hero-sections');
        Route::post('/{homepageHeroSection}/set-active', [HomepageHeroSectionController::class, 'setActive'])->middleware('privilege:update-homepage-hero-sections');
    });

    // Homepage About Us Section routes (Admin)
    Route::prefix('homepage-about-us-sections')->group(function () {
        Route::get('/', [HomepageAboutUsSectionController::class, 'index'])->middleware('privilege:read-homepage-about-us-sections');
        Route::get('/{homepageAboutUsSection}', [HomepageAboutUsSectionController::class, 'showById'])->middleware('privilege:read-homepage-about-us-sections');
        Route::post('/', [HomepageAboutUsSectionController::class, 'store'])->middleware('privilege:create-homepage-about-us-sections');
        Route::put('/{homepageAboutUsSection}', [HomepageAboutUsSectionController::class, 'update'])->middleware('privilege:update-homepage-about-us-sections');
        Route::delete('/{homepageAboutUsSection}', [HomepageAboutUsSectionController::class, 'destroy'])->middleware('privilege:delete-homepage-about-us-sections');
        Route::post('/{homepageAboutUsSection}/set-active', [HomepageAboutUsSectionController::class, 'setActive'])->middleware('privilege:update-homepage-about-us-sections');
    });

    // Homepage CTA Section routes (Admin)
    Route::prefix('homepage-cta-sections')->group(function () {
        Route::get('/', [HomepageCtaSectionController::class, 'index'])->middleware('privilege:read-homepage-cta-sections');
        Route::get('/{homepageCtaSection}', [HomepageCtaSectionController::class, 'showById'])->middleware('privilege:read-homepage-cta-sections');
        Route::post('/', [HomepageCtaSectionController::class, 'store'])->middleware('privilege:create-homepage-cta-sections');
        Route::put('/{homepageCtaSection}', [HomepageCtaSectionController::class, 'update'])->middleware('privilege:update-homepage-cta-sections');
        Route::delete('/{homepageCtaSection}', [HomepageCtaSectionController::class, 'destroy'])->middleware('privilege:delete-homepage-cta-sections');
        Route::post('/{homepageCtaSection}/set-active', [HomepageCtaSectionController::class, 'setActive'])->middleware('privilege:update-homepage-cta-sections');
    });
});
